<?php 
  header("Content-type: text/css"); 
  $primary_color = file_get_contents("../css/screenTxt.txt");
  // $primary_color = "#eb4034";
?>

/* @charset "utf-8"; */
/* CSS Document */

/* screen.css */
@import url('https://fonts.googleapis.com/css?family=Roboto+Condensed:400,700|Roboto:400,500,700,900');

@font-face {
  font-family: 'FontAwesome';
  src: url('../font/fontawesome-webfont.eot?v=3.0.1');
  src: url('../font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
    url('../font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
    url('../font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
  font-weight: normal;
  font-style: normal;
}


/* COLOR SETUP */
:root {
  --primary-color: <?=$primary_color?>;
  --secondary-color: #75a9ff;
  --third-color: #0d0d0d;
  --primary-bgcolor: #000;
  --ratingstars-color: #ffb109;
}

a {
    color: #fff;
    text-decoration: none;
	outline: none;
}

a:hover, a:active, a:focus {
  outline: none;
}

input::-moz-focus-inner { 
  border: 0; 
}

object, embed { 
  outline: 0;
}

.fa {
	
}

a:hover, a:focus {
    color: #fff;
    text-decoration: none;
}

/* BASE */
html, body { height: 100% !important; height:auto; margin: 0 auto;  background-color: var(--primary-bgcolor, #000);}
html { font-size:100%; }
body {font-size:16px;color:#fff;font-family: 'Roboto Condensed', sans-serif;background-color: #000;text-decoration:none;margin:0;padding:0;}


h1,h2,h3,h4,h5,h6 {
	font-family: 'Roboto Condensed', sans-serif;
	font-weight:lighter;
}

h4 {
	margin:15px 0;
}

h2 {
	font-weight:900 !important;
	text-transform:uppercase;
	font-size:30px;
	letter-spacing: -0.6px;
	margin:10px 0;
	display:inline-block;
}

h2.title {	
	border-left:7px solid var(--primary-color);
	padding-left:10px;
	font-weight:900 !important;
    transform: skew(-15deg);
    -webkit-transform: skew(-15deg);
    -moz-transform: skew(-15deg);
    -o-transform: skew(-15deg);
    -ms-transform: skew(-15deg);
	text-transform:uppercase;
	font-size:30px;
	letter-spacing: -0.6px;
	margin:30px 0;
}

h2.icon {
	border-left:0;
	padding-left:0;
	font-weight:900 !important;
    transform: skew(-15deg);
    -webkit-transform: skew(-15deg);
    -moz-transform: skew(-15deg);
    -o-transform: skew(-15deg);
    -ms-transform: skew(-15deg);
	text-transform:uppercase;
	font-size:30px;
	letter-spacing: -0.6px;
	margin:0px 0px 15px 0;
}

h2.icon i {
	transform: skew(15deg);
    -webkit-transform: skew(15deg);
    -moz-transform: skew(15deg);
    -o-transform: skew(15deg);
    -ms-transform: skew(15deg);
	display:inline-block;
	border:5px solid var(--primary-color);
	font-size:24px !important;
	margin-right:10px;
	border-radius:50%;
	color:#fff;
	transition: all 0.1s linear 0s;
	padding-top:7px;
	vertical-align: middle;
	text-align:center;
	width:50px;
	height:50px;
}

h2.icon:hover i {
	border:5px solid var(--secondary-color);
}

aside h2.title {margin:15px 0;}

h2.main-head-title {display:block; margin-top:0; margin-left: 8px;}

/* CLEARFIX */
.clearfix:after {content : "."; display : block; clear : both; visibility : hidden; line-height : 0; height : 0;}

section {margin:10px 0; display:block;}
.spacer {height:1px; margin:10px 0; padding:10px 0; display:inline-block; width:100%;}

.dir-right {float:right;}

.header-top {
	/*
	background:#0d0d0d url('../img/backgrounds/top-background-img.jpg') no-repeat center top fixed;
    background-repeat: no-repeat;
	*/
	
	border-top: 5px solid var(--primary-color);
	padding-top:15px;
}

.main-logo {
	display:inline-block;
	margin-top:15px;
	margin-bottom:15px;
	
}

.banner-l {display:inline-block; text-align:center;}


/* BACKGROUNDS */
.standard-bg{
	padding-top:0px;
	background:#080b12 url('../img/backgrounds/blue-background-img.jpg') no-repeat center top fixed;
    -webkit-background-size: cover;
    -moz-background-size: cover;
    background-size: cover;
    -o-background-size: cover;
	 background-attachment: fixed;
    background-position: center;
    background-repeat: no-repeat;
	padding-bottom: 30px;
}

.channels-bg {
	background:#080b12 url('../img/backgrounds/bottom-bg-img.png') no-repeat center top fixed;
    background-repeat: no-repeat;
	background-size:cover;
	border-top: 5px solid var(--primary-color);
}

.footer-background {
	padding-top:80px;
	padding-bottom:80px;
	background:#080b12 url('../img/backgrounds/bottom-bg-img.png') no-repeat center center fixed;
    -webkit-background-size: cover;
    -moz-background-size: cover;
    background-size: cover;
    -o-background-size: cover;
	 background-attachment: fixed;
    background-position: center;
    background-repeat: no-repeat;
}

.featured-bg {
	padding-top:80px;
	padding-bottom:80px;
	background:#080b12 url('../img/backgrounds/bottom-bg-img.png') no-repeat center center fixed;
    -webkit-background-size: cover;
    -moz-background-size: cover;
    background-size: cover;
    -o-background-size: cover;
	 background-attachment: fixed;
    background-position: center;
    background-repeat: no-repeat;
}

.review-bg {
	background: #080b12 url('../img/backgrounds/review-background-img.jpg') no-repeat center top fixed;
    background-repeat: no-repeat;
}



#bottom-banner {padding:50px;}
#review aside {margin-top:0;}

/* MISC */
.ratings {
	display:block;
	color: var(--ratingstars-color);
	margin:20px 0;
}

.play-btn {
	padding:18px 20px;
	border-radius:50%;
	background: rgba(0, 0, 0, 0.4);
	display:inline-block;
	z-index:999;
	
	transition: all 0.1s linear 0s;
}

.play-btn-border {
	background: rgba(0, 0, 0, 0.6);
	border-radius:50%;
	padding:15px 0px;
	display:inline-block;
	z-index:2;
	opacity:0;
	position: absolute;
	left:50%;
	top:50%;
	transition: all 0.1s linear 0s;
	transform: translate(-50%, -50%) scale(1.4, 1.4);
}

.post:hover .play-btn-border {
	opacity:1;
	transform: translate(-50%, -50%) scale(1, 1);
}

.play-btn-border i:hover {
	border:5px solid var(--secondary-color);
	padding:10px 14px;
	border-radius:50%;
	color:#fff;
}

.fa-play-circle {
	color:#fff;
	border:10px;
	font-size:36px !important;
	transition: all 0.1s linear 0s;
}

.post:hover .fa-play-circle{
	color:#fff;
}

.post:hover .play-btn {
	background: rgba(0, 0, 0, 0.8);
	opacity:1;
} 

.skew-btn {
	font-family: 'Roboto Condensed', sans-serif;
	color:#0d0d0d;
	padding:5px 10px;
	background: var(--secondary-color);
	transform: skew(-15deg);
    -webkit-transform: skew(-15deg);
    -moz-transform: skew(-15deg);
    -o-transform: skew(-15deg);
    -ms-transform: skew(-15deg);
	text-transform:uppercase;
	font-size:14px;
	display:inline-block;
	font-weight:600;
	transition: all 0.1s linear 0s;
}


/* COMMENTS */
.widget-area {
	background-color: transparent;
	display:block;
}
.comment-box-control {
	display:inline-block;
	padding:15px;
	width:100%;
}
.status-upload {
	background-color: rgba(7,7,7, 0.7);
	display:inline-block;
	width: 100%;
	border-radius: 8px;
}
.status-upload form {
	float: left;
	width: 100%;
}
.status-upload form textarea {
	background: none repeat scroll 0 0 #fff;
	border: medium none;
	color: #777777;
	float: left;
	font-size: 16px;
	height: 142px;
	letter-spacing: 0.3px;
	padding: 20px;
	width: 100%;
	resize:vertical;
	outline:none;
	border: 1px solid #ddd;
}

.status-upload ul {
	float: left;
	list-style: none outside none;
	margin: 0;
	padding: 0;
	width: auto;
}
.status-upload ul > li {
	float: left;
	margin:5px;
}
.status-upload ul > li > a {
	color: #777777;
	display:inline-block;
	font-size: 16px;
	padding: 15px;
	text-align: center;
	-webkit-transition: all 0.4s ease 0s;
	-moz-transition: all 0.4s ease 0s;
	-ms-transition: all 0.4s ease 0s;
	-o-transition: all 0.4s ease 0s;
	transition: all 0.4s ease 0s;
	cursor: pointer;
	border-radius:50%;
	width:50px;
	height:50px;
}
.status-upload ul > li > a:hover {
	background-color: var(--primary-color);
	color: #fff;
	border-radius:100%;
}
.status-upload form button {
	border: medium none;
	color: #fff;
	font-size: 16px;
	letter-spacing: 0.3px;
	margin:0;
	padding: 10px 15px;
	border-radius:0;
	background: var(--primary-color);
	text-transform:uppercase;
	transition: all 0.1s linear 0s;
	border-radius:8px;
}

.status-upload form button:hover {
	background:#fff;
	color:#777777;
}



.status-upload form button > i {
	margin-right: 7px;
}

/* COMMENT PANELS */
.comment-posts {
	display:inline-block;
	width:100%;
	margin: 20px 0;
}
.comment-posts .thumbnail {
	padding:0;
	border-radius:0;
	background: transparent;
    border: 0;
}
.comment-posts article {
	margin-bottom:20px;
	display:inline-block;
}
.panel {
	border-radius:0;
	font-size:16px;
	color:#1a1a1a;
	border:none;
	border-radius:8px;
}
.panel-heading {
	border:none;
	border-radius:0;
	background: var(--primary-color) !important;
	color:#fff !important;
	border-radius:8px 8px 0 0;
}


.panel>.panel-heading:before{
	border-right-color:#ddd;
	border-width:8px;
}

.comment-posts img.user-photo  {border-radius:100%;}


/* CAROUSEL */
.carousel-control-box {position:relative; float:right;}
.carousel-control {text-shadow: 0 0 0; width:auto; position:relative; color:#fff; opacity:1;}
.carousel-control:hover, .carousel-control:focus {
	color: var(--secondary-color);
}
.carousel-control i {font-size:24px;}
.carousel-control.left, .carousel-control.right {background:rgba(0, 0, 0, 0) none repeat scroll 0 0; margin:0 10px;}
.carousel {display:block; margin:20px 0;}
.carousel-indicators {width:auto; margin:20px 0 !important; padding:0; float: left; position:absolute; left:-40px; top:40%;}

.carousel-indicators li {display:block; margin:5px 0; height:12px; width:12px;}
.carousel-inner {margin:15px 0 30px 0; display:inline-block; 
    padding-right: 10px;
    padding-left: 10px;}
.carousel-indicators li {border:3px solid var(--primary-color);  transition: all 0.1s linear 0s;}
.carousel-indicators .active {border:3px solid var(--secondary-color); margin:5px 0; background:transparent;}

.carousel-inner .item {padding-top: 10px;}

/* CHANNELS ****************/
.posts-channel {
	color:#fff;
	font-size:14px;
	text-align:left;
}

.posts-channel i {
	color: var(--primary-color);
	padding-right:15px;
}

.3-right-posts .thumbr {
	width:50%;
}

.mbm {margin-bottom:20px;}


/* POSTS *******************/


#home-main2 article:nth-child(3n+1) {
    clear: left;
}

#home-main3 article:nth-child(3n+1) {
    clear: left;
}

#home-main4 article:nth-child(6n+1) {
    clear: left;
}

#home-main5 article:nth-child(6n+1) {
    clear: left;
}



#home-main article,
#home-main2 article,
#home-main3 article,
#home-main4 article,
#home-main5 article,
#channels article,
#main-reviews article {margin-bottom:20px;}
#home-carousel {margin-top:0;}
#home-carousel .carousel-inner {margin-top:0;}
#home-carousel .carousel-control-box {
    position: absolute;
    z-index: 20;
    right: 0;
    padding: 25px;
}

a.title {opacity:1; transition: all 0.1s linear 0s;}
a.title:hover {opacity:0.6}


a.post-thumb {
    background-color: #000000;
    display: block;
    overflow: hidden;
	position:relative;
	border-radius:8px;
	-webkit-transform: translate3d(0,0,0);
	-moz-transform: translate3d(0,0,0);
	-ms-transform: translate3d(0,0,0);
	-o-transform: translate3d(0,0,0);
	transform: translate3d(0,0,0);
}
.post {transition: all 0.1s linear 0s;}
.post:hover img { opacity: 0.4; -moz-opacity:0.4; -webkit-opacity:0.4; filter: alpha(opacity=40); transform: scale(1.2); border-radius: 8px; }
.post img {opacity: 1; transition: all 0.1s linear 0s;}
.thumbr img { width: 100%; border-radius: 8px;

}



.post:hover  .thumbr {transition: all 0.1s linear 0s; z-index:999; transform: scale(1.02); }

.post:hover .thumbr {
	-webkit-box-shadow: 0px 30px 13px -21px rgba(0,0,0,1);
	-moz-box-shadow: 0px 30px 13px -21px rgba(0,0,0,1);
	box-shadow: 0px 30px 13px -21px rgba(0,0,0,1);
}

.headline-round {
	border:5px solid var(--primary-color);
	padding:10px 14px;
	border-radius:50%;
	color:#fff;
}

.posts-txt {color:#fff; font-size:14px; text-align:left; }
.posts-txt i {color:#fff; padding-right:15px; }
.fa-thumbs-up { color:#fff;}
.infor .ratings {float:right; display:inline-block; margin:0;}

/* VIDEO TIME */
.cactus-note.ct-time {
    left: auto;
    margin-left: auto;
    margin-right: 12px;
    right: 0;
	font-size:12px;
}

.cactus-note {
    background-color: var(--primary-color);
    bottom: 0;
    color: #fff;
    left: 0;
    line-height: 1;
    margin-bottom: 10px;
    margin-left: 10px;
	margin-right:15px;
    padding: 5px 10px;
    position: absolute;
	z-index:500;
	border-radius:3px;
}

/* MAIN ROLL */
#editor-choice article { margin-bottom:40px;}
#editor-choice article:nth-child(2n+1) { clear: left;}
#main-roll-1 h2 {margin-top:0;}
#myCarousel3 h2 {margin-top:0;}
.tab-pane .post {margin-bottom:40px;}

.reviews .thumbr { 
    border-radius: 100%;
    border:7px solid var(--primary-color);
	overflow:hidden;
	background-size: cover;
}

.reviews .thumbr:hover { 
    border-radius: 100%;
    border:7px solid var(--secondary-color);
	overflow:hidden;
	transform: scale(1);
}

.reviews .thumbr img {
	display:block;
	min-width: 100%;
    min-height: 100%;
	border-radius:100%;
	overflow:hidden;
}

.review-number {
	position:absolute;
	color:#fff;
	font-size:24px;
	font-weight:600;
	padding:15px 0px;
	display:inline-block;
	z-index:999;
	opacity:0;
	position: absolute;
	left:43%;
	top:37%;
	transition: all 0.2s linear 0s;
}

.post:hover .review-number {opacity:1;}
.reviews .post {text-align:center; }
.reviews .post .infor .ratings {float:none;}
.flag i {position:absolute; left:-26px; top:-7px;}
.flag1 {border-left: 30px solid var(--secondary-color);}
.flag {
    border-bottom: 30px solid transparent;
    border-left: 30px solid var(--secondary-color);
    border-top: 30px solid transparent;
    height: 0;
    width: 0;
	position: absolute;
    top: 40px;
    z-index: 100;
}

/* BANNERS */
.banner-md {margin:25px 0; display:block;}
#featured-video h2.title {border-left:7px solid var(--secondary-color);}
#main, #tabs, #footer {padding:50px 0;}

/* SIDEBAR */
aside {
	border:3px solid var(--primary-color);
	padding:20px;
	border-radius:10px;
	margin:0px;
	transition: all 0.1s linear 0s;
}

aside:hover {border:3px solid var(--secondary-color);}

/* SIDEBAR */
ul.sidebar-links {
    display: block;
    list-style: outside none none;
    margin: 25px 0;
    padding: 0;
}

ul.sidebar-links li::before {
    color: #fff;
    font-size: 11px;
    padding-right: 10px;
}

ul.sidebar-links li {
	display:block;
    margin-bottom: 10px;
	border-bottom:1px solid #191919;
	padding-bottom:10px
}

ul.sidebar-links li a {
    color: #fff;
    text-decoration: none;
	font-family: 'Roboto Condensed', sans-serif;
	font-weight:500;
	text-transform:uppercase;
	transition: all 0.1s linear 0s;
	letter-spacing:-0.4px;
}

ul.sidebar-links li span {
    color: #fff;
	float:right;
	font-size:14px;
    text-decoration: none;
	font-family: 'Roboto Condensed', sans-serif;
	font-weight:500;
	text-transform:uppercase;
	transition: all 0.1s linear 0s;
}

ul.sidebar-links li:hover a,
ul.sidebar-links li:hover::before,
ul.sidebar-links li:hover span {
	color: var(--secondary-color);
}

ul.sidebar-links li:last-child {border-bottom:0;}


/* BOOTSTRAP TABS */
.nav-tabs > li.active > a, .nav-tabs > li.active > a:hover, .nav-tabs > li.active > a:focus {
	background:transparent;
	border:0;
	color:#fff;
}

.nav-tabs > li.active > a h2.title, .nav-tabs > li.active > a:hover h2.title, .nav-tabs > li.active > a:focus h2.title {
	border-left:7px solid var(--secondary-color);
}

.nav-tabs > li {
	float:none;
	display:inline-block;
}
.nav-tabs > li > a {
	border:0;
	color:#fff;
	border-radius:0;
	transition: all 0.1s linear 0s;
}
.nav-tabs > li > a:hover, .nav-tabs > li > a:focus {
	background:transparent;
	border:0;
}

.nav-tabs > li > a > h2.title {
	transition: all 0.1s linear 0s;
}
.nav-tabs > li > a:hover h2.title {
	border-left:7px solid var(--secondary-color);
	color: var(--secondary-color);
}
.nav-tabs {
	border:0;
}

.dark-bg {
	background-color: rgba(7,7,7, 0.7);
}




/* FOOTER */
footer .post-medium {margin-bottom:20px;}
ul.footer-menu-links { list-style: outside none none;margin: 25px 0; padding: 0;}
ul.footer-menu-links li::before { color: #8e8e8e; font-size: 11px; padding-right: 20px;}
ul.footer-menu-links li {margin-bottom: 30px;}
ul.footer-menu-links li a {
    color: #fff;
    text-decoration: none;
	font-family: 'Roboto Condensed', sans-serif;
	font-weight:500;
	text-transform:uppercase;
	transition: all 0.1s linear 0s;
}
ul.footer-menu-links li:hover a,
ul.footer-menu-links li:hover::before {color: var(--secondary-color);}

ul.footer-tags {display:block; list-style:none; padding:0; margin: 10px 0;}
ul.footer-tags li {display:inline-block; background:#373737; margin:5px; padding:6px 12px; border-radius:4px;}
ul.footer-tags li a { color:#fff;  font-size:14px; line-height: 18px; text-decoration:none; text-align:center;}
ul.footer-tags li:hover {background: var(--secondary-color); text-decoration:none; transition: all 0.1s linear 0s;}

.footer-logo {margin-left:40%;display:block;margin-top:30px;margin-bottom:30px;}
.copyright-bottom {padding-top:20px;}

/* SOCIAL ICONSET */
.social-facebook {background:#2951a7;}
.social-twitter {background:#37b1ff;}
.social-google-plus {background:#fc2e15;}
.social-youtube {background:#df1e1a;}
.social-vimeo {background:#17aee1;}
.social-rss {background:#fd7120;}
ul.social {margin: 30px 0;display:inline-block;padding-left:0;}
ul.social li {
    padding: 0 2px 0 2px;
	width:35px;
    border-radius:10px;
	margin:0 2px;
	transition: all 0.1s linear 0s;
	display:inline-block;
	list-style:none;
	text-align:center;
	opacity:1;
}
ul.social li:hover {opacity:0.6;}
ul.social li a {
	display:block;
    color: #ffffff;
    font-size: 18px;
    font-weight: 400;
    height: auto;
    letter-spacing: -1px;
    padding: 8px 6px;
    text-decoration: none;
    text-transform: uppercase;
    transition: all 0.1s linear 0s;
    width: auto;
}

/* SUBSCRIBE BOX */
.subscribe-box {
    background: transparent;
	border:3px solid var(--primary-color);
    padding: 20px;
    text-align: center;
	display:inline-block;
	margin:0;
	transition: all 0.1s linear 0s;
	border-radius:10px;
	margin:0 20px 30px 20px;;
}

.subscribe-box:hover {border:3px solid var(--secondary-color);}
.subscribe-box h2.head {margin:5px 0; float:none; display:inline-block; margin-bottom:20px;}
.subscribe-btn {display:block; border:1px solid var(--primary-color); width:100%; height:auto; background-color:var(--primary-color); cursor:pointer; padding:12px; color:#fff; text-align:center; transition: all 0.1s linear 0s; border-radius:4px;}
.subscribe-btn:hover { border:1px solid transparent; background:var(--secondary-color); color:#fff;}
.subscribe-box #subscribe,
aside #subscribe {margin-bottom:15px;}
.subscribe-box p {
	color: #fff;
	font-style:italic;
    display:inline-block;
    font-size: 14px;
    margin: 10px 0;
	text-align:center;
}

.navbar-nav {margin:0;}

.home-mega-menu .social {float:right; margin:10px;}

.sidebar-search {display:inline-block; margin-bottom:25px;}
.search-panel {display:block;}
.sidebar article,
footer article {margin-bottom:20px;}



.thumbr, .infor {display:block;border-radius: 8px;}

/* INPUTS */
input, select, textarea {
	border:1px solid #fff;
    border-bottom: 3px solid var(--primary-color);
    color: #595959;
    display: block;
    float: left;
    font-size: 16px;
    height: auto;
    padding: 12px;
    transition: all 0.2s linear 0s;
    unicode-bidi: embed;
    width: 100%;
	background: transparent;
	font-style:italic;
	border-radius:8px;
}

input[type=text]:focus, input[type=password]:focus, input[type=url]:focus, input[type=email]:focus, input.text:focus, input.title:focus, textarea:focus {color:#ffffff; border-bottom:3px solid var(--secondary-color);}
input.search:focus { color:#ffffff !important; }

/* -- SEARCH FORM --*/
.search-block {display:block; margin-top:20px; margin-right: 15px; margin-left: 15px;}
input[type=search] {-webkit-appearance: textfield;-webkit-box-sizing: content-box;font-family: inherit;font-size: 100%;}
input[type=search] {
	background: #fff url("../img/search-icon.png") no-repeat 5px 10px;
	border: 0;
	padding: 7px 7px 7px 25px;
	width: 0px;
	font-size:16px;
	-webkit-transition: all .5s;
	-moz-transition: all .5s;
	transition: all .5s;
	border-radius:4px;
	
	border-right:10px solid var(--primary-color);
}
input[type=search]:focus {width: 130px; background-color: #fff; font-size:16px; }
input:-moz-placeholder {color: #fff;}
input::-webkit-input-placeholder {color: #fff;}
input::-webkit-search-decoration,
input::-webkit-search-cancel-button {
	display: none; 
}

.search-block {
    display: inline-block;
    margin-left: 15px;
    margin-right: 15px;
    margin-top: 12px;
	float:right;
}

.up-text {
    bottom: 0;
    float: left;
    height: auto;
    padding: 2em;
    position: absolute;
    width: 100%;
    z-index: 999;
}

span.m-tag {
    border: 1px solid #fff;
    color: #ffffff;
    display: inline-block;
    font-size: 12px;
    padding: 10px 15px;
    text-transform: uppercase;
    transition: all 0.2s ease-out 0s;
    width: auto;
    z-index: 999;
}

.flood {
	height: 0;
    left: 50%;
    margin-left: -30px;
    margin-top: -50px;
    position: absolute;
    top: 50%;
    width: 0;
	z-index:999;
	display:inline-block;
}

.metabox {display:block;margin:10px 0 20px 0;}
.metabox .ratings {display:inline-block;margin:5px 0;}
.metabox a {color:#fff;}
.metabox a:hover {color: var(--secondary-color);}


span.meta-i {
	display:inline-block;
	font-size:16px;
	font-weight:400;
	margin-right:30px;
	margin-bottom:15px;
}
span.meta-i i {margin-right:10px;}

.video-info .ratings {
	display:inline-block;
	margin:5px 0;
}
.video-right-banner {
	display:inline-block;
	margin:20px; padding:20px;
	background:rgba(0,0,0,0.4);
}
.video-info ul.social {margin:5px 0;}

.video-info {
	border-top-left-radius: 8px;
	border-top-right-radius: 8px;
	border-bottom-left-radius: 8px;
	border-bottom-right-radius: 8px;
	transition: all 0.2s ease-out 0s;
	background-color: #1e1e1e;
	display:block;
	padding: 20px 20px 20px 20px;
	border-top: 5px solid var(--primary-color);
}

#single-video-wrapper .video-info,
#single-video .video-info,
#single-video-fullwidth-wrapper .video-info,
#single-video-right-sidebar-wrapper .video-info,
#single-video-no-sidebar-wrapper .video-info,
#author-bio-wrapper .video-info  {
	padding: 0px 20px 20px 20px;
}

#category3-section .review-number {
	position:relative;
	display:block;
	opacity:1;
	left:0;
	top:0;
	margin:5px 0;
	font-size:18px;
	padding:5px 0;
}

#review .video-info .social {margin-top:25px;}
.page-info .ratings {display:inline-block;margin:5px 0;}
.page-right-banner {
	display:inline-block;
	margin:20px; padding:20px;
	background:rgba(0,0,0,0.4);
}
.page-info ul.social {margin:5px 0;}

.gap-bottom { margin-bottom: 25px;}
.gap-right {margin-right: 25px;}

blockquote {border-left:3px solid var(--primary-color);}
blockquote footer {color:#fff;}

/* SHARE INPUT */
.share-input {display:inline-block;width:100%;}
.share-input i {position:absolute:}
.sharelinkicon {
    float: right;
    margin-right: 6px;
    margin-top: -35px;
    position: relative;
    z-index: 2;
    color: #fff;
}
.share-input input {
	display: inline-block;
    background: #373737;
	color:#fff;
    margin: 5px;
    padding: 10px 20px;
    border-radius: 4px;
}






.scale-top {margin-top:-199px;}


.social-login {
	display:block;
}

.login-header h2 {
	display:inline-block;
}

.msx {
	color: #fff;
  text-decoration: none;
  background-color: #1e1e1e;
  border-left:8px solid var(--primary-color);
}

.video-embed-box {
	display:block;
	margin-bottom:80px;
	bottom:10px;
	margin-right: -20px;
    margin-left: -20px;
	border-radius: 8px 8px 0 0;
    border-bottom: 5px solid #0d0d0d;
}

.registration .social-login .social-login-btn {
    display:block;
    margin-bottom: 20px;
	border-radius:6px;
	padding:10px;
	opacity:1;
}



.registration .social-login .social-login-btn a {
    display: block;
    font-size: 14px;
    text-transform: capitalize;
    -webkit-border-radius: 4px;
    -moz-border-radius: 4px;
    -ms-border-radius: 4px;
    border-radius: 4px;
    font-weight: bold;
}

.registration .social-login .social-login-btn:hover {
	opacity: 0.8;
	transition: all 0.2s ease-out 0s;
}


.registration .social-login .social-login-btn a i {
    display: inline-block;
    width: 25px;
    line-height: 25px;
    height: 25px;
    text-align: center;
    margin-right: 10px;
    font-size: 16px;
	
}

.registration .middle-sep{
    margin: 0;
    position: absolute;
    top: 150px;
    left: 30%;
    display:inline-block;
}


.login-inputicon {
    float: none;
	padding:15px;
    position: absolute;
    z-index: 2;
    color: #ddd;
	margin-right:25px;
	border-right:1px solid #ddd;
}



.register-form .checkbox {
	display:inline-block; 
}
.checkbox input {margin-left:0; padding-left:0;}
.checkbox input[type="checkbox"] {margin-left:0; padding-left:0; width:20px;}
.checkbox label {padding-left:30px;}
.register-form .input-group {
	margin-bottom:15px;
	display:inline-block;
	width:100%;
}

.register-form input {
	display:inline-block;
	border:1px solid #ddd;
	padding:12px 12px 12px 55px;
	background: #fff;
	border-radius:6px;
}

.login-btn-box {
	text-align:right;
}



.registration .register-form .input-group .input-group-label i {
    color: #6c6c6c;
    font-size: 16px;
}
.review-lines {
	display:block;
}
.rev-box {
    width: 100%;
    background-color: #1e1e1e;
	border-radius:6px;
	display:block;
	margin-bottom:20px;
}

.review-lines span.label {font-size:16px; color:#fff; margin:5px 0;}

.revprogress {
    text-align: right; 
    padding-right: 20px; 
    line-height: 18px;
    color: white;
	border-radius:6px;
}

.level1 {width: 90%; background-color: #ea0000; background-image: linear-gradient(to bottom, #ea0000, #900000);} 
.level2 {width: 80%; background-color: #fcbe16; background-image: linear-gradient(to bottom, #fcbe16, #dd7a0f);} 
.level3 {width: 65%; background-color: #6d33ff; background-image: linear-gradient(to bottom, #6d33ff, #2f0696);} 

.content-box-opa {
	border: 3px solid var(--primary-color);
    padding: 20px;
    border-radius: 10px;
    margin: 0px;
}

#contact-page form {
	display:inline-block;
}

#comment-form button {
	display:inline-block;
	margin:35px 0 15px 0;
}

#comment-form input, select, textarea {
	border: 0;
    border-bottom: 3px solid #fff;
    color: #595959;
    display: block;
    float: left;
    font-size: 16px;
    height: auto;
    padding: 12px;
    transition: all 0.2s linear 0s;
    unicode-bidi: embed;
    width: 100%;
    background: #fff;
    font-style: italic;
	border-radius:8px;
	margin-bottom:15px;
}

.contact-info {display:block;}
.contact-info ul {
	display:inline-block;
	margin:0;
	padding:0;
}

.contact-info ul li {
	display:block;
	margin:0;
	margin-bottom:8px;
	padding:0;
}

.contact-info ul li {
	font-family: 'Roboto Condensed', sans-serif;
    transition: all 0.1s linear 0s;
	color:#fff;
}

.contact-info ul li ,
.contact-info ul li a {
    
	color:#fff;
}

.contact-info ul li a:hover {
	color: var(--secondary-color);
}

.contact-info ul li::before {
	font-family: FontAwesome;
    color: #fff;
    font-size: 12px;
    padding-right: 20px;
}

.map-frame {
	border:0;
	border-radius:8px;
	min-height:400px;
}

.map-frame iframe {
	height:500px;
	width:100%;
	border-radius:8px;
}

/* MEGAMENU */
.no-padding {padding-left:-15px; padding-right:-15px; margin-right: 0px;
margin-left: 0px;}

.no-margin { margin-right: -15px;
margin-left: -15px;}


.navbar-nav>li>.dropdown-menu {
  margin-top: 0px;
  padding-top:8px;
  padding-bottom:8px;
  border-top-left-radius: 8px;
  border-top-right-radius: 8px;
  border-bottom-left-radius: 8px;
  border-bottom-right-radius: 8px;
  transition: all 0.2s ease-out 0s;
  background-color: #fff;
}

.dropdown-menu > li > a {
	font-size:18px;
	padding: 10px 80px 10px 30px;
	background-color: #fff;
	transition: all 0.2s ease-in-out;
}

.dropdown-menu > li > a:hover,
.dropdown-menu > li > a:focus {
  color: #fff;
  text-decoration: none;
  background-color: #1e1e1e;
  border-left:8px solid var(--primary-color);
}

.dropdown-menu {left:auto;}

.navbar-toggle {
    position: relative;
    float: right;
    padding: 15px 14px;
    margin-top: 8px;
    margin-right: 15px;
    margin-bottom: 8px;
    background-color: var(--primary-color);
    background-image: none;
    border: 1px solid var(--primary-color);
    border-radius: 4px;
}
.navbar-default .navbar-toggle:hover, .navbar-default .navbar-toggle:focus {background-color: var(--primary-color); border: 1px solid var(--primary-color);}
.navbar-default .navbar-toggle {border-color: var(--primary-color);}
.navbar-default .navbar-toggle .icon-bar {background-color: #fff;}
.navbar-default .navbar-nav>li>a:before {transition: all 0.1s linear 0s;}

.navbar-default .navbar-nav>li>a {
  color:#fff !important;
  font-size:20px;
  letter-spacing:-0.5px;
  font-weight: 600;
  text-transform: uppercase;
  line-height:30px;
  transition: all 0.1s linear 0s;
  background:transparent;
  border-radius:6px;
  padding-top:5px;
  padding-bottom:5px;
  margin-top:10px;
  margin-bottom:10px;
}



.navbar-default .navbar-nav>li>a:hover {
	transition: all 0.1s linear 0s;
	background: var(--primary-color);
	/*
	background: rgb(236,0,0);
	background: -moz-linear-gradient(top,  rgba(236,0,0,1) 0%, rgba(135,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(236,0,0,1) 0%,rgba(135,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(236,0,0,1) 0%,rgba(135,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ec0000', endColorstr='#870000',GradientType=0 );
	*/
	
	color:#fff;
	border-radius:6px;
}


.navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus, .navbar-default .navbar-nav > .open > a:active {
	transition: all 0.1s linear 0s;
	background: var(--primary-color);
	/*
	background: rgb(236,0,0);
	background: -moz-linear-gradient(top,  rgba(236,0,0,1) 0%, rgba(135,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(236,0,0,1) 0%,rgba(135,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(236,0,0,1) 0%,rgba(135,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ec0000', endColorstr='#870000',GradientType=0 );
	*/
	
	color:#fff !important;
}


.access-btn {
		transition: all 0.3s linear 0s;
	margin-left:50px;
	background: var(--primary-color);
	/*
	background: rgb(144,0,0);
	background: -moz-linear-gradient(top,  rgba(234,0,0,1) 0%, rgba(144,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(234,0,0,1) 0%,rgba(144,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(234,0,0,1) 0%,rgba(144,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ea0000', endColorstr='#900000',GradientType=0 );
	*/
	
	color: #fff;
    font-size: 20px;
    font-weight: 600;
    letter-spacing: -0.5px;
    line-height: 30px;
    text-transform: uppercase;
	font-style:italic;
	padding:8px 20px;
	border:0;
	border-radius:5px;
	opacity: 1;
}

.access-btn:hover {
	background: var(--primary-color);
	opacity: 0.7;
	/*
	background: rgb(144,0,0);
	background: -moz-linear-gradient(top,  rgba(144,0,0,1) 0%, rgba(234,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(144,0,0,1) 0%,rgba(234,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(144,0,0,1) 0%,rgba(234,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#900000', endColorstr='#ea0000',GradientType=0 );
	*/
}

.right-box {
	float:right;
	padding:40px 0 0 0;
}

.right-box a.link {
	font-size:16px;
	text-decoration:none;
}
.right-box a.link:hover {
	transition: all 0.3s linear 0s;
	font-size:16px;
	text-decoration:underline;
}


/* MENU */
.mega-dropdown {
  position: static !important;
  transition: all 0.2s ease-out 0s;
}

.mega-dropdown-menu {
  padding: 20px 0px;
  width: 100%;
  box-shadow: none;
  -webkit-box-shadow: none;
}

.mega-dropdown-menu > li > ul {
  padding: 0;
  margin: 0;
  transition: all 0.2s ease-out 0s;
}

.mega-dropdown-menu > li > ul > li {
  list-style: none;
}

.mega-dropdown-menu > li > ul > li > a {
  display: block;
  padding: 3px 20px;
  clear: both;
  font-weight: normal;
  line-height: 1.428571429;
  color: #999;
  white-space: normal;
}

.mega-dropdown-menu > li ul > li > a:hover,
.mega-dropdown-menu > li ul > li > a:focus {
  text-decoration: none;
  color: #fff;
  background-color: var(--primary-color);
}

.dropdown-menu .divider {
	background-color: #2d2d2d;
}

.mega-dropdown-menu .dropdown-header {

  
	color: #fff;
	font-size: 20px;
	font-weight: 600;
	letter-spacing: -0.5px;
	line-height: 30px;
	text-transform: uppercase;
	transform: skew(-15deg);
	transition: all 0.2s ease-in-out 0s;
}

.mega-dropdown-menu form {
  margin: 3px 20px;
}

.mega-dropdown-menu .form-group {
  margin-bottom: 3px;
}

.dropshd {
	-webkit-box-shadow: 0px 0px 6px 3px rgba(0,0,0,0.5);
	-moz-box-shadow: 0px 0px 6px 3px rgba(0,0,0,0.5);
	box-shadow: 0px 0px 6px 3px rgba(0,0,0,0.5);
}

.megabg {
	background: rgb(41,41,41);
	background: -moz-linear-gradient(top,  rgba(41,41,41,1) 28%, rgba(12,12,12,1) 76%);
	background: -webkit-linear-gradient(top,  rgba(41,41,41,1) 28%,rgba(12,12,12,1) 76%);
	background: linear-gradient(to bottom,  rgba(41,41,41,1) 28%,rgba(12,12,12,1) 76%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#292929', endColorstr='#0c0c0c',GradientType=0 );
	
}
.main-carousel h2 {}
.main-carousel .post-meta {display:block;}
.main-carousel .ratings {display:inline-block; float:right; margin:0;}
.main-carousel .carousel-inner {margin-bottom:0;}


.navbar-default .navbar-collapse, .navbar-default .navbar-form {
	border-radius:6px;
}
.navbar {
	border-radius:6px;
	border:0;
}

.navbar-default {
	background:transparent;
}

.mega-dropdown-menu {
	z-index:999;
	box-shadow: 0 0 6px 3px rgba(0, 0, 0, 0.5);
	background:#111111;
}

.dropdown-menu {
	z-index:999;
}
.infor h4 {font-size:18px;}
.main-large-post .thumbr {position:relative;}
.main-large-post .infor {position:absolute; z-index:999; bottom:0; padding:15px 30px; width:100%;
	background: -moz-linear-gradient(top,  rgba(0,0,0,0) 0%, rgba(0,0,0,0.13) 18%, rgba(0,0,0,0.33) 36%, rgba(0,0,0,0.74) 70%, rgba(0,0,0,0.91) 87%, rgba(0,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(0,0,0,0) 0%,rgba(0,0,0,0.13) 18%,rgba(0,0,0,0.33) 36%,rgba(0,0,0,0.74) 70%,rgba(0,0,0,0.91) 87%,rgba(0,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(0,0,0,0) 0%,rgba(0,0,0,0.13) 18%,rgba(0,0,0,0.33) 36%,rgba(0,0,0,0.74) 70%,rgba(0,0,0,0.91) 87%,rgba(0,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#00000000', endColorstr='#000000',GradientType=0 );

}
.main-large-post .infor h4 {font-size:36px;}
.main-large-post .cactus-note {display:inline-block; position:relative; margin-right:0;}
.main-large-post .vid-time-block {display:block; width:100%; margin:15px 0px 0px 0px; bottom:0; text-align:right;}


.small-post .thumbr {position:relative;}
.small-post .infor {position:absolute; z-index:999; bottom:0; padding:30px 30px 10px 30px; width:100%;
	background: -moz-linear-gradient(top,  rgba(0,0,0,0) 0%, rgba(0,0,0,0.13) 18%, rgba(0,0,0,0.33) 36%, rgba(0,0,0,0.74) 70%, rgba(0,0,0,0.91) 87%, rgba(0,0,0,1) 100%);
	background: -webkit-linear-gradient(top,  rgba(0,0,0,0) 0%,rgba(0,0,0,0.13) 18%,rgba(0,0,0,0.33) 36%,rgba(0,0,0,0.74) 70%,rgba(0,0,0,0.91) 87%,rgba(0,0,0,1) 100%);
	background: linear-gradient(to bottom,  rgba(0,0,0,0) 0%,rgba(0,0,0,0.13) 18%,rgba(0,0,0,0.33) 36%,rgba(0,0,0,0.74) 70%,rgba(0,0,0,0.91) 87%,rgba(0,0,0,1) 100%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#00000000', endColorstr='#000000',GradientType=0 );

}
.small-post .infor h4 {font-size:20px;}
.small-post .cactus-note {display:inline-block; position:relative; margin-right:0;}
.small-post .vid-time-block {display:block; width:100%; margin:15px 0px 0px 0px; bottom:0; text-align:right;}


#cur-view article { margin-bottom:25px;}

.author-cover-img {
	width:100%;
	display:inline-block;
}
.author-cover-img img {
		border-radius:8px;
}

.home-small-posts  .ratings {float:none; margin:0 20px;}
.home-small-posts .ct-time {float:right;}
.home-small-posts {text-align:left !important;}


.filter-box {display:block; padding:10px; margin-bottom:20px;}
.filter-box button {border:none; color:#1a1a1a; font-size:16px; text-transform:uppercase; border-radius:0; box-shadow:none !important; padding:10px 15px; border-radius:6px; transition: all 0.2s ease-in-out 0s;}
.btn-default.active, .filter-box button:hover, .btn-default.active:hover {background: var(--primary-color); color:#fff; border-radius:6px;}



/* MODAL */
.modal-content {border-radius:8px; background:#000; padding:20px;}
#enquirypopup .modal-dialog {
    width: 400px;
    padding: 0px ;
    position: relative;
	border:0;
}

#enquirypopup .modal-dialog {
    width: 400px;
    padding: 0px ;
    position: relative;
}

.modal-dialog {margin-top:100px;}

.custom-modal-header {
    text-align: center;
    color: #fff;
    text-transform: uppercase;
    letter-spacing: 2px;
}

.modal-header {border:0;}

#enquirypopup .modal-dialog .close {
    z-index: 99999999;
    color: white;
    text-shadow: 0px 0px 0px;
    font-weight: normal;
    top: 12px;
    right: 14px;
    position: absolute;
    opacity: 1;
}


.form-group {
    margin-bottom: 15px !important;
}

.form-inline .form-control {
    display: inline-block;
    width: 100%;
    vertical-align: middle;
	padding:12px;
	height:auto;
}

.form-inline .form-control input {
	color:#000;
}


.breadcrumb {
    background: none;
    padding-left: 0;
}

.breadcrumb {
    margin-bottom: 15px;
}

.breadcrumb a:hover {color:var(--secondary-color);}
.breadcrumb > .active {color: var(--secondary-color);}

.pagination > li > a, .pagination > li > span {
	background: rgb(41,41,41);
	background: -moz-linear-gradient(top,  rgba(41,41,41,1) 28%, rgba(12,12,12,1) 76%);
	background: -webkit-linear-gradient(top,  rgba(41,41,41,1) 28%,rgba(12,12,12,1) 76%);
	background: linear-gradient(to bottom,  rgba(41,41,41,1) 28%,rgba(12,12,12,1) 76%);
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#292929', endColorstr='#0c0c0c',GradientType=0 );
	border:0;
	color:#fff;
	padding:15px 15px;
	font-size:18px;
}

.pagination > li > a:hover,
.pagination > li > span:hover,
.pagination > li > a:focus,
.pagination > li > span:focus {
  z-index: 2;
  transition: all 0.1s linear 0s;
	background: var(--primary-color);
	
	color:#fff;
	

}

.pagi {
	border-color: #ddd;
    border-image: none;
    border-style: solid;
    border-width: 0px 0;
    padding: 1em 0;
    text-align: center;
}


#category2 article .ratings,
#category3 article .ratings {
	display:block;
	float:none;
}

#category3 article h4 {font-size:24px;}


#single-video .nosidebar-related-videos article,
#category .category-video-grid article,
#category2 .category-video-grid article,
.category-video-grid article {
		margin-bottom:25px;
}

.category-video-grid .post {margin-bottom:25px;}

#category3 .category-video-grid article {
	margin-bottom:40px;
}



.author-stats {
	display:block;
}

ul.stats {
	list-style:none;
	margin:0;
	padding:0;
}

ul.stats > li {
	display:inline-block;
	text-align:center;
	padding:0 15px;
}

.number-text {
	display:inline-block;
}

span.join-date {
	display:block;
	font-size:14px;
	font-weight:normal;
	margin:15px 0;
}

.fancybox-slide--video .fancybox-content {
	width  : 800px;
	height : 600px;
	max-width  : 80%;
	max-height : 80%;
}


.review-details .ratings {display:block;}
.review-xs-thumbs {
	display:block;
	margin-top:15px;
}

.review-xs-thumbs a {
	display:inline-block;
}

.review-xs-thumbs a img {
	display:inline-block;
	border-radius:6px;
}



/*********** RESPONSIVE **************/
/*************************************/
@media (min-width: 768px) and (max-width: 1024px) {
		.right-box {padding:40px 90px 0 0;}
		.navbar-default .navbar-toggle { position:absolute; right:0; top:-103px;}
        .navbar-nav .open .dropdown-menu {
            position: static;
            float: none;
            width: auto;
            margin-top: 0;
            background-color: #fff;
            border: 0;
            -webkit-box-shadow: none;
            box-shadow: none;
        }
        .navbar-nav .open .dropdown-menu > li > a {
            line-height: 30px;
        }
        .navbar-nav .open .dropdown-menu > li > a,
        .navbar-nav .open .dropdown-menu .dropdown-header {
            padding: 5px 15px 5px 25px;
        }
        .dropdown-menu > li > a {
            display: block;
            padding: 3px 20px;
            clear: both;
            font-weight: normal;
            line-height: 1.42857143;
            color: #333;
            white-space: nowrap;
        }
        .navbar-header {
            float: none;
        }
        .navbar-toggle {
            display: block;
        }
        .navbar-collapse {
            border-top: 1px solid transparent;
            box-shadow: inset 0 1px 0 rgba(255,255,255,0.1);
        }
        .navbar-collapse.collapse {
            display: none!important;
        }
        .navbar-nav {
            float: none!important;
            
        }
        .navbar-nav>li {
            float: none;
        }
        .navbar-nav>li>a {
            padding-top: 10px;
            padding-bottom: 10px;
        }
        .navbar-text {
            float: none;
            margin: 15px 0;
        }
        /* since 3.1.0 */
        .navbar-collapse.collapse.in { 
            display: block!important;
        }
        .collapsing {
            overflow: hidden!important;
        }
}


/*==========  Non-Mobile First Method  ==========*/

/* Large Devices, Wide Screens */
@media only screen and (max-width : 1200px) {
	
	.infor h4 {font-size:24px; line-height:30px;}
	ul.sidebar-links li a {font-size:20px;}
	ul.sidebar-links li span {font-size:18px;}
	.carousel-control i {font-size:36px;}
	
	.subscribe-box {display:block;}
	h2.icon {font-size:36px;}
	.cactus-note.ct-time {font-size:16px;}
	.infor h4 {font-size:24px; line-height:30px;}
	.posts-txt {font-size:18px;}
	input {font-size:18px;}
	.subscribe-btn {font-size:22px;}
	.main-large-post .infor h4 {font-size:48px; line-height:54px;}
	.small-post .infor h4 {font-size:30px; line-height:36px;}
	
	#tabs li h2 {font-size:36px;}

}

/* Medium Devices, Desktops */
@media only screen and (max-width : 992px) {
	
	
	.subscribe-box {display:block;}
	h2.icon {font-size:36px;}
	.cactus-note.ct-time {font-size:16px;}
	.infor h4 {font-size:24px; line-height:30px;}
	.posts-txt {font-size:18px;}
	input {font-size:18px;}
	.subscribe-btn {font-size:22px;}
	.main-large-post .infor h4 {font-size:48px; line-height:54px;}
	.small-post .infor h4 {font-size:30px; line-height:36px;}

	#tabs li h2 {font-size:36px;}

	
	ul.sidebar-links li a {font-size:20px;}
	ul.sidebar-links li span {font-size:18px;}
	
	.carousel-control i {font-size:36px;}
	
	.map-frame {margin-bottom:30px;}
	
	.review-xs-thumbs .post {margin-bottom:20px;}
}

/* Small Devices, Tablets */
@media only screen and (max-width : 768px) {
	.footer-logo {margin-left:35%;}
	#contact-page form {display:block;}
	.subscribe-box {display:block;}
	h2.icon {font-size:36px;}
	.cactus-note.ct-time {font-size:16px;}
	.infor h4 {font-size:24px; line-height:30px;}
	.posts-txt {font-size:18px;}
	input {font-size:18px;}
	.subscribe-btn {font-size:22px;}
	.main-large-post .infor h4 {font-size:48px; line-height:54px;}
	.small-post .infor h4 {font-size:30px; line-height:36px;}

	#tabs li h2 {font-size:36px;}
	.map-frame {margin-bottom:30px;}
	
	.review-xs-thumbs .post {margin-bottom:20px;}
}

/* Extra Small Devices, Phones */ 
@media only screen and (max-width : 480px) {
	.footer-logo {margin-left: 20%;}
	.navbar-default .navbar-toggle {
		position: absolute;
		right: 0;
		top: -103px;
	}
	
	#tabs h2.title {margin:10px 0;}
	.main-large-post .infor h4 {font-size:30px; line-height:36px;}
}

/* Custom, iPhone Retina */ 
@media only screen and (max-width : 320px) {
	
}

@media (min-width:1200px){
    .auto-clear .col-lg-1:nth-child(12n+1){clear:left;}
    .auto-clear .col-lg-2:nth-child(6n+1){clear:left;}
    .auto-clear .col-lg-3:nth-child(4n+1){clear:left;}
    .auto-clear .col-lg-4:nth-child(3n+1){clear:left;}
    .auto-clear .col-lg-6:nth-child(odd){clear:left;}
}
@media (min-width:992px) and (max-width:1199px){
    .auto-clear .col-md-1:nth-child(12n+1){clear:left;}
    .auto-clear .col-md-2:nth-child(6n+1){clear:left;}
    .auto-clear .col-md-3:nth-child(4n+1){clear:left;}
    .auto-clear .col-md-4:nth-child(3n+1){clear:left;}
    .auto-clear .col-md-6:nth-child(odd){clear:left;}
}
@media (min-width:768px) and (max-width:991px){
    .auto-clear .col-sm-1:nth-child(12n+1){clear:left;}
    .auto-clear .col-sm-2:nth-child(6n+1){clear:left;}
    .auto-clear .col-sm-3:nth-child(4n+1){clear:left;}
    .auto-clear .col-sm-4:nth-child(3n+1){clear:left;}
    .auto-clear .col-sm-6:nth-child(odd){clear:left;}
}
@media (max-width:767px){
    .auto-clear .col-xs-1:nth-child(12n+1){clear:left;}
    .auto-clear .col-xs-2:nth-child(6n+1){clear:left;}
    .auto-clear .col-xs-3:nth-child(4n+1){clear:left;}
    .auto-clear .col-xs-4:nth-child(3n+1){clear:left;}
    .auto-clear .col-xs-6:nth-child(odd){clear:left;}
}
