<?php
/*
  █████╗ ██████╗ ██╗  ██╗██╗   ██╗ █████╗ ██╗   ██╗██╗   ████████╗
 ██╔══██╗██╔══██╗██║ ██╔╝██║   ██║██╔══██╗██║   ██║██║   ╚══██╔══╝
 ███████║██████╔╝█████╔╝ ██║   ██║███████║██║   ██║██║      ██║
 ██╔══██║██╔═══╝ ██╔═██╗ ╚██╗ ██╔╝██╔══██║██║   ██║██║      ██║
 ██║  ██║██║     ██║  ██╗ ╚████╔╝ ██║  ██║╚██████╔╝███████╗ ██║
 ╚═╝  ╚═╝╚═╝     ╚═╝  ╚═╝  ╚═══╝  ╚═╝  ╚═╝ ╚═════╝ ╚══════╝ ╚═╝

                APKVAULT PANEL
                by @Phantom_681
                https://t.me/Phantom_681
*/
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo e($panelName); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" crossorigin="anonymous">
    <link href="assets/css/theme.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
        }
        
        .login-card {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            box-shadow: var(--shadow-md);
            padding: 2rem;
            width: 100%;
            max-width: 400px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        
        .login-header h1 {
            color: var(--text);
            font-weight: 600;
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }
        
        .login-header p {
            color: var(--text-muted);
            font-size: 0.875rem;
        }
        
        .default-credentials {
            text-align: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border);
            color: var(--text-muted);
            font-size: 0.8125rem;
        }
        
        @media (max-width: 576px) {
            .login-card {
                padding: 1.5rem;
            }
            
            .login-header h1 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="login-header">
            <?php if ($logoUrl): ?>
                <img src="<?php echo e($logoUrl); ?>" alt="Panel Logo" style="height: 48px; margin-bottom: 1rem; display: block; margin-left: auto; margin-right: auto;">
            <?php endif; ?>
            <h1><?php echo e($panelName); ?></h1>
            <p>Sign in to continue</p>
        </div>
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="<?php echo url('index.php'); ?>" id="loginForm">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfToken); ?>">
            
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" class="form-control" id="username" name="username" required autofocus>
            </div>
            
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            
            <button type="submit" name="login" value="1" class="btn btn-primary w-100">
                Login
            </button>
        </form>
        
        <div class="default-credentials">
            Default: admin / admin<br>
            <small>⚠️ Change immediately in production!</small>
        </div>
    </div>
    
    <script>
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"]');
            if (btn) {
                btn.disabled = true;
                btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Logging in...';
            }
        });
    </script>
</body>
</html>

