//  █████╗ ██████╗ ██╗  ██╗██╗   ██╗ █████╗ ██╗   ██╗██╗   ████████╗
// ██╔══██╗██╔══██╗██║ ██╔╝██║   ██║██╔══██╗██║   ██║██║   ╚══██╔══╝
// ███████║██████╔╝█████╔╝ ██║   ██║███████║██║   ██║██║      ██║   
// ██╔══██║██╔═══╝ ██╔═██╗ ╚██╗ ██╔╝██╔══██║██║   ██║██║      ██║   
// ██║  ██║██║     ██║  ██╗ ╚████╔╝ ██║  ██║╚██████╔╝███████╗ ██║   
// ╚═╝  ╚═╝╚═╝     ╚═╝  ╚═╝  ╚═══╝  ╚═╝  ╚═╝ ╚═════╝ ╚══════╝ ╚═╝   
//
//                       APKVAULT PANEL
//
//                by @Phantom_681
//                https://t.me/Phantom_681
//

document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert:not(.alert-permanent)');
    alerts.forEach(function(alert) {
        setTimeout(function() {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, 5000);
    });
});

function copyToClipboard(text, successMessage) {
    navigator.clipboard.writeText(text).then(function() {
        const toast = document.createElement('div');
        toast.className = 'alert alert-success position-fixed top-0 end-0 m-3';
        toast.style.zIndex = '9999';
        toast.innerHTML = '<i class="bi bi-check-circle"></i> ' + (successMessage || 'Copied to clipboard!');
        document.body.appendChild(toast);
        
        setTimeout(function() {
            toast.remove();
        }, 3000);
    }).catch(function(err) {
        console.error('Failed to copy:', err);
    });
}

function confirmDelete(message) {
    return confirm(message || 'Are you sure you want to delete this item?');
}

function setupCharCounter(textareaId, maxLength, counterId) {
    const textarea = document.getElementById(textareaId);
    const counter = document.getElementById(counterId);
    
    if (textarea && counter) {
        function updateCounter() {
            const length = textarea.value.length;
            counter.textContent = length;
            
            if (length > maxLength) {
                counter.style.color = '#f85149';
            } else if (length > maxLength * 0.9) {
                counter.style.color = '#f59e0b';
            } else {
                counter.style.color = '#8b949e';
            }
        }
        
        textarea.addEventListener('input', updateCounter);
        updateCounter();
    }
}



document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const toggleBtn = document.getElementById('sidebarToggle');
    const backdrop = document.getElementById('sidebarBackdrop');

    if (!sidebar || !toggleBtn || !backdrop) return;

    function openSidebar() {
        sidebar.classList.add('open');
        backdrop.classList.add('show');
        document.body.style.overflow = 'hidden';
        toggleBtn.setAttribute('aria-label', 'Close menu');
    }

    function closeSidebar() {
        sidebar.classList.remove('open');
        backdrop.classList.remove('show');
        document.body.style.overflow = '';
        toggleBtn.setAttribute('aria-label', 'Open menu');
    }

    toggleBtn.addEventListener('click', function() {
        if (sidebar.classList.contains('open')) closeSidebar();
        else openSidebar();
    });

    backdrop.addEventListener('click', closeSidebar);

    sidebar.addEventListener('click', function(e) {
        const link = e.target.closest('a');
        if (link && window.matchMedia('(max-width: 768px)').matches) {
            closeSidebar();
        }
    });


    window.addEventListener('resize', function() {
        if (!window.matchMedia('(max-width: 768px)').matches) {
            closeSidebar();
        }
    });
});
