<?php
include('includes/header.php');

// Load current content.json
$json_file = 'download/content.json';
$content = file_exists($json_file) ? json_decode(file_get_contents($json_file), true) : [];
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    // Collect form data
    $new_content = [
        'page' => [
            'title' => trim($_POST['page_title'])
        ],
        'hero' => [
            'title' => trim($_POST['hero_title']),
            'subtitle' => trim($_POST['hero_subtitle']),
            'download_link' => trim($_POST['hero_download_link']),
            'image_url' => trim($_POST['hero_image_url'])
        ],
        'info' => [
            'title' => trim($_POST['info_title']),
            'description' => trim($_POST['info_description']),
            'features' => [
                [
                    'title' => trim($_POST['feature_1_title']),
                    'description' => trim($_POST['feature_1_description'])
                ],
                [
                    'title' => trim($_POST['feature_2_title']),
                    'description' => trim($_POST['feature_2_description'])
                ],
                [
                    'title' => trim($_POST['feature_3_title']),
                    'description' => trim($_POST['feature_3_description'])
                ]
            ]
        ],
        'download' => [
            'title' => trim($_POST['download_title']),
            'description' => trim($_POST['download_description']),
            'button' => trim($_POST['download_button']),
            'download_link' => trim($_POST['download_download_link']),
            'downloader_title' => trim($_POST['download_downloader_title']),
            'downloader_code' => trim($_POST['download_downloader_code']),
            'downloader_invalid' => trim($_POST['download_downloader_invalid'])
        ],
        'contact' => [
            'title' => trim($_POST['contact_title']),
            'description' => trim($_POST['contact_description']),
            'button' => trim($_POST['contact_button']),
            'email' => trim($_POST['contact_email'])
        ]
    ];

    // Validate required fields (basic validation)
    $required_fields = [
        'page_title', 'hero_title', 'hero_subtitle', 'hero_download_link', 'hero_image_url',
        'info_title', 'info_description', 'feature_1_title', 'feature_1_description',
        'feature_2_title', 'feature_2_description', 'feature_3_title', 'feature_3_description',
        'download_title', 'download_description', 'download_button', 'download_download_link',
        'download_downloader_title', 'download_downloader_code', 'download_downloader_invalid',
        'contact_title', 'contact_description', 'contact_button', 'contact_email'
    ];
    $is_valid = true;
    foreach ($required_fields as $field) {
        if (empty(trim($_POST[$field]))) {
            $is_valid = false;
            $error_message = 'All fields are required.';
            break;
        }
    }

    if ($is_valid) {
        // Save to content.json
        if (file_put_contents($json_file, json_encode($new_content, JSON_PRETTY_PRINT))) {
            $success_message = 'Content updated successfully!';
            $content = $new_content; // Update content for form display
        } else {
            $error_message = 'Error saving content. Please check file permissions.';
        }
    }
}
?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Landing Page</h2>
                    <h5><i class="icon icon-bullhorn"></i> This is an additional feature that you get through the admin panel. It has been added to make it easier for you to promote your app to your customers. You can easily customize your App page through the following. Using this is not mandatory.</h5>
                </center>
            </div>
            
            <div class="card-body">
                <?php if ($success_message): ?>
                    <div class="alert alert-success"><?php echo $success_message; ?></div>
                <?php endif; ?>
                <?php if ($error_message): ?>
                    <div class="alert alert-danger"><?php echo $error_message; ?></div>
                <?php endif; ?>
                <form method="post">
                    <div class="form-group ctinput">
                        <!-- Page -->
                        <h4>Page</h4>
                        <div class="mb-3">
                            <label for="page_title" class="form-label">Page Title</label>
                            <input type="text" class="form-control" id="page_title" name="page_title" value="<?php echo htmlspecialchars($content['page']['title'] ?? ''); ?>">
                        </div>

                        <!-- Hero -->
                        <h4>Hero Section</h4>
                        <div class="mb-3">
                            <label for="hero_title" class="form-label">Title</label>
                            <input type="text" class="form-control" id="hero_title" name="hero_title" value="<?php echo htmlspecialchars($content['hero']['title'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="hero_subtitle" class="form-label">Subtitle</label>
                            <input type="text" class="form-control" id="hero_subtitle" name="hero_subtitle" value="<?php echo htmlspecialchars($content['hero']['subtitle'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="hero_download_link" class="form-label">Download Link</label>
                            <input type="url" class="form-control" id="hero_download_link" name="hero_download_link" value="<?php echo htmlspecialchars($content['hero']['download_link'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="hero_image_url" class="form-label">Image URL</label>
                            <input type="url" class="form-control" id="hero_image_url" name="hero_image_url" value="<?php echo htmlspecialchars($content['hero']['image_url'] ?? ''); ?>">
                        </div>

                        <!-- Info -->
                        <h4>Info Section</h4>
                        <div class="mb-3">
                            <label for="info_title" class="form-label">Title</label>
                            <input type="text" class="form-control" id="info_title" name="info_title" value="<?php echo htmlspecialchars($content['info']['title'] ?? ''); ?>">
                            <label for="info_description" class="form-label ctinput">Description</label>
                            <textarea class="form-control ctinput" id="info_description" name="info_description"><?php echo htmlspecialchars($content['info']['description'] ?? ''); ?></textarea>
                        </div>
                        <h5>Features</h5>
                        <?php for ($i = 1; $i <= 3; $i++): ?>
                            <div class="mb-3">
                                <label for="feature_<?php echo $i; ?>_title" class="form-label">Feature <?php echo $i; ?> Title</label>
                                <input type="text" class="form-control" id="feature_<?php echo $i; ?>_title" name="feature_<?php echo $i; ?>_title" value="<?php echo htmlspecialchars($content['info']['features'][$i-1]['title'] ?? ''); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="feature_<?php echo $i; ?>_description" class="form-label">Feature <?php echo $i; ?> Description</label>
                                <textarea class="form-control" id="feature_<?php echo $i; ?>_description" name="feature_<?php echo $i; ?>_description"><?php echo htmlspecialchars($content['info']['features'][$i-1]['description'] ?? ''); ?></textarea>
                            </div>
                        <?php endfor; ?>

                        <!-- Download -->
                        <h4>Download Section</h4>
                        <div class="mb-3">
                            <label for="download_title" class="form-label">Title</label>
                            <input type="text" class="form-control" id="download_title" name="download_title" value="<?php echo htmlspecialchars($content['download']['title'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="download_description" class="form-label">Description</label>
                            <textarea class="form-control" id="download_description" name="download_description"><?php echo htmlspecialchars($content['download']['description'] ?? ''); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="download_button" class="form-label">Button Text</label>
                            <input type="text" class="form-control" id="download_button" name="download_button" value="<?php echo htmlspecialchars($content['download']['button'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="download_download_link" class="form-label">Download Link</label>
                            <input type="url" class="form-control" id="download_download_link" name="download_download_link" value="<?php echo htmlspecialchars($content['download']['download_link'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <input type="hidden" class="form-control" id="download_downloader_title" name="download_downloader_title" value="<?php echo htmlspecialchars($content['download']['downloader_title'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="download_downloader_code" class="form-label">Downloader Code</label>
                            <input type="text" class="form-control" id="download_downloader_code" name="download_downloader_code" value="<?php echo htmlspecialchars($content['download']['downloader_code'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="download_downloader_invalid" class="form-label">Downloader Invalid Message</label>
                            <input type="text" class="form-control" id="download_downloader_invalid" name="download_downloader_invalid" value="<?php echo htmlspecialchars($content['download']['downloader_invalid'] ?? ''); ?>">
                        </div>

                        <!-- Contact -->
                        <h4>Contact Section</h4>
                        <div class="mb-3">
                            <label for="contact_title" class="form-label">Title</label>
                            <input type="text" class="form-control" id="contact_title" name="contact_title" value="<?php echo htmlspecialchars($content['contact']['title'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="contact_description" class="form-label">Description</label>
                            <textarea class="form-control" id="contact_description" name="contact_description"><?php echo htmlspecialchars($content['contact']['description'] ?? ''); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="contact_button" class="form-label">Button Text</label>
                            <input type="text" class="form-control" id="contact_button" name="contact_button" value="<?php echo htmlspecialchars($content['contact']['button'] ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="contact_email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="contact_email" name="contact_email" value="<?php echo htmlspecialchars($content['contact']['email'] ?? ''); ?>">
                        </div>
                    </div>
                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>