<?php
header('Content-Type: text/html; charset=UTF-8');
$name = $_GET['name'] ?? 'RTX Rebrand';
// Define variables
$text = $name;
$rings = 2;
$ringSectors = 30;

// Generate sectors for each ring
$sectors = str_split($text);
$sectorHtml = '';
for ($s = 0; $s < $ringSectors; ++$s) {
    $sectorContent = isset($sectors[$s]) ? $sectors[$s] : '';
    $sectorHtml .= "<div class=\"preloader__sector\">{$sectorContent}</div>";
}

// Generate rings
$ringHtml = '';
for ($r = 0; $r < $rings; ++$r) {
    $ringHtml .= "<div class=\"preloader__ring\">{$sectorHtml}</div>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RTX Rebrand Preloader</title>
    <style>
        * {
            border: 0;
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        :root {
            font-size: calc(16px + (24 - 16) * (100vw - 320px) / (1280 - 320));
        }

        body, .preloader {
            display: flex;
        }

        body {
            background: #000;
            color: #3df1f1;
            font: 1em 'Dosis', sans-serif;
            height: 100vh;
            line-height: 1.5;
            perspective: 40em;
        }

        .preloader {
            animation: tiltSpin 8s linear infinite;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            margin: auto;
            width: 17em;
            height: 17em;
            transform-style: preserve-3d;
        }

        .preloader__ring {
            animation: spin 4s linear infinite;
            font-size: 2em;
            position: relative;
            height: 3rem;
            width: 1.5rem;
            transform-style: preserve-3d;
        }

        .preloader__ring:nth-child(even) {
            animation-direction: reverse;
        }

        .preloader__sector {
            font-weight: 600;
            position: absolute;
            top: 0;
            left: 0;
            text-align: center;
            text-transform: uppercase;
            transform: translateZ(7rem);
        }

        .preloader__sector, .preloader__sector:empty:before {
            display: inline-block;
            width: 100%;
            height: 100%;
        }

        .preloader__sector:empty:before {
            background: linear-gradient(transparent 45%, currentColor 45% 55%, transparent 55%);
            content: "";
        }

        <?php
        // Generate sector rotations
        for ($s = 2; $s <= $ringSectors; $s++) {
            $angle = (360 / $ringSectors) * ($s - 1);
            echo ".preloader__sector:nth-child({$s}) {";
            echo "transform: rotateY({$angle}deg) translateZ(7rem);";
            echo "}";
        }
        ?>

        @keyframes tiltSpin {
            from {
                transform: rotateY(0) rotateX(30deg);
            }
            to {
                transform: rotateY(360deg) rotateX(30deg);
            }
        }

        @keyframes spin {
            from {
                transform: rotateY(0);
            }
            to {
                transform: rotateY(360deg);
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@600&display=swap" rel="stylesheet">
</head>
<body>
    <div class="preloader">
        <?php echo $ringHtml; ?>
    </div>
</body>
</html>