<?php 
include ('includes/json_utils.php');
include ('includes/header.php');

$page_name = 'backdrop_tube';
$table_name = 'bdtube';

// Insert initial data if the table is empty
$data = ['link' => 'https://www.youtube.com/watch?v=o4qjk8_5gmU'];
$db->insertIfEmpty($table_name, $data);

// Retrieve the existing data for display
$res = $db->select($table_name, '*', '', '');

// Handle form submission
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". $page_name.".php?status=1'</script>";
}


function getCurrentDateTimeMd5() {
  $dateTime = date('Y-m-d H:i:s');
  $md5Hash = md5($dateTime);
  return $md5Hash;
}

// Extract YouTube video ID from the URL
function getYouTubeVideoId($url) {
    $videoId = '';
    if (preg_match('/(youtube\.com\/watch\?v=|youtu\.be\/)([a-zA-Z0-9_-]+)/', $url, $matches)) {
        $videoId = $matches[2];
    }
    return $videoId;
}

$videoId = getYouTubeVideoId($res[0]['link']);

?>

<div class="col-md-6 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card text-white ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Backdrop YouTube</h2>
                </center>
            </div>
            
            <div class="card-body">
                <form method="post">
                    
                    <div class="form-group ctinput">
                        <label class="form-label"> YouTube link :</label>
                        <div class="form-group ctinput">
                            <input class="form-control" id="link" name="link" value="<?php echo $res[0]['link']?>"
                                placeholder="Eg: https://www.youtube.com/watch?v=o4qjk8_5gmU" type="text" />
                        </div>
                    </div>


                    <div class="form-group ctinputform-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Update
                            </button>
                        </center>
                    </div>
                </form>
            </div>       
        </div>
    </div>
</div>
<?php include ('includes/footer.php');?>
