<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php
        // Load JSON content
        $json_file = 'content.json';
        $content = file_exists($json_file) ? json_decode(file_get_contents($json_file), true) : [];
        if (empty($content)) {
            die('Error loading content. Please ensure content.json exists.');
        }
        echo htmlspecialchars($content['page']['title']);
    ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            color: #ffffff;
            overflow-x: hidden;
            background: linear-gradient(-45deg, #1e3a8a, #60a5fa, #7c3aed, #db2777);
            background-size: 400% 400%;
            animation: gradient 15s ease infinite;
        }
        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        .hero {
            background: url('https://i.ibb.co/m5kJwCgg/2148115379.jpg') no-repeat center center/cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            position: relative;
        }
        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
        }
        .app-screenshot {
            max-width: 100%;
            height: auto;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }
        .info-section {
            background: #ffffff;
            color: #1f2937;
            padding: 4rem 2rem;
        }
        .download-btn, .contact-btn, .downloader-btn {
            transition: transform 0.3s ease, background-color 0.3s ease;
        }
        .download-btn:hover

        .download-btn:hover, .contact-btn:hover, .downloader-btn:hover {
            transform: scale(1.05);
            background-color: #2563eb;
        }
        .downloader-input {
            border: 2px solid #e5e7eb;
            border-radius: 0.5rem;
            padding: 0.75rem;
            width: 100%;
            max-width: 300px;
            margin-bottom: 1rem;
            color: #1f2937;
        }
        .downloader-input:focus {
            outline: none;
            border-color: #2563eb;
        }
        @media (max-width: 640px) {
            .hero {
                height: 80vh;
            }
            .app-screenshot {
                width: 80%;
            }
            .info-section {
                padding: 2rem 1rem;
            }
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <section class="hero">
        <div class="relative z-10">
            <h1 class="text-2xl font-bold mb-4"></h1>
            <h1 class="text-1xl font-bold mb-4"></h1>
            <h1 class="text-5xl md:text-6xl font-bold mb-4"><?php echo htmlspecialchars($content['hero']['title']); ?></h1>
            <p class="text-xl md:text-2xl mb-6"><?php echo htmlspecialchars($content['hero']['subtitle']); ?></p>
            <img src="<?php echo htmlspecialchars($content['hero']['image_url']); ?>" alt="App Screenshot" class="app-screenshot mx-auto ">
            <a href="<?php echo htmlspecialchars($content['hero']['download_link']); ?>" class="download-btn bg-blue-600 text-white px-8 py-4 rounded-full text-lg font-semibold"><?php echo htmlspecialchars($content['download']['button']); ?></a>
            <a/>
            <a/>
            <h1 class="text-2xl font-bold mb-4"></h1>
            <h1 class="text-1xl font-bold mb-4"></h1>
            <h1 class="text-1xl font-bold mb-4"></h1>
            <h1 class="text-1xl font-bold mb-3">or</h1>
            <h1 class="text-1xl font-bold mb-3"><?php echo htmlspecialchars($content['download']['downloader_title']); ?></h1>
            <h3 class="text-2xl font-bold mb-4"><?php echo htmlspecialchars($content['download']['downloader_code']); ?></h3>
        </div>
    </section>

    <!-- Info Section -->
    <section class="info-section">
        <div class="max-w-5xl mx-auto text-center">
            <h2 class="text-3xl md:text-4xl font-bold mb-6"><?php echo htmlspecialchars($content['info']['title']); ?></h2>
            <p class="text-lg mb-8"><?php echo htmlspecialchars($content['info']['description']); ?></p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <?php foreach ($content['info']['features'] as $feature): ?>
                    <div>
                        <h3 class="text-xl font-semibold mb-2"><?php echo htmlspecialchars($feature['title']); ?></h3>
                        <p><?php echo htmlspecialchars($feature['description']); ?></p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Download Section -->
    <section id="download" class="py-16 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6"><?php echo htmlspecialchars($content['download']['title']); ?></h2>
        <p class="text-lg mb-8"><?php echo htmlspecialchars($content['download']['description']); ?></p>
        <?php
            $download_count = isset($_COOKIE['download_count']) ? (int)$_COOKIE['download_count'] : 0;
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['download'])) {
                $download_count++;
                setcookie('download_count', $download_count, time() + (86400 * 30)); // 30 days
                header('Location: #download'); // Prevent form resubmission
                exit;
            }
        ?>
        <form method="POST" class="mb-4">
            <a href="<?php echo htmlspecialchars($content['download']['download_link']); ?>" class="download-btn bg-blue-600 text-white px-8 py-4 rounded-full text-lg font-semibold"><?php echo htmlspecialchars($content['download']['button']); ?></a>
        </form>

        <!-- Downloader Code Section -->
        <h1 class="text-2xl font-bold mb-4"><?php echo htmlspecialchars($content['download']['downloader_title']); ?></h1>
        <h3 class="text-2xl font-bold mb-4"><?php echo htmlspecialchars($content['download']['downloader_code']); ?></h3>
        <?php
            $code_message = '';
            $code_urls = [
                '2452879' => 'https://nextgenapp.com/downloads/firetv.apk'
            ];
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['downloader_code'])) {
                $entered_code = trim($_POST['downloader_code']);
                if (array_key_exists($entered_code, $code_urls)) {
                    $code_message = "Success! Download from: <a href='{$code_urls[$entered_code]}' class='text-blue-400 underline'>{$code_urls[$entered_code]}</a>";
                } else {
                    $code_message = htmlspecialchars($content['download']['downloader_invalid']);
                }
            }
        ?>
        <?php if ($code_message): ?>
            <p class="text-lg"><?php echo $code_message; ?></p>
        <?php endif; ?>
    </section>

    <!-- Contact Section -->
    <section class="py-16 text-center bg-gray-900">
        <h2 class="text-3xl md:text-4xl font-bold mb-6"><?php echo htmlspecialchars($content['contact']['title']); ?></h2>
        <p class="text-lg mb-8"><?php echo htmlspecialchars($content['contact']['description']); ?></p>
        <a href="mailto:<?php echo htmlspecialchars($content['contact']['email']); ?>" class="contact-btn bg-blue-600 text-white px-8 py-4 rounded-full text-lg font-semibold"><?php echo htmlspecialchars($content['contact']['button']); ?></a>
    </section>

    <!-- PHP Download Counter Logic -->
    <?php
        if (!isset($_COOKIE['download_count'])) {
            setcookie('download_count', 0, time() + (86400 * 30)); // Initialize cookie
        }
    ?>
</body>
</html>